/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.rcp.databinding;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.eclipse.core.databinding.BindingException;

final class Utils {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    Utils() {
    }

    public static Method getMethod(Class<?> beanClass, String propertyName) {
        PropertyDescriptor descriptor;
        if (propertyName != null && (descriptor = Utils.getPropertyDescriptor(beanClass, propertyName)) != null) {
            return descriptor.getReadMethod();
        }
        return null;
    }

    public static Object invokeMethod(Method method, Class<?> beanClass, Object element) {
        if (method != null && Utils.instanceOf(beanClass, element)) {
            try {
                return method.invoke(element, EMPTY_ARRAY);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static boolean instanceOf(Class<?> beanClass, Object element) {
        return element != null && beanClass.isAssignableFrom(element.getClass());
    }

    private static PropertyDescriptor getPropertyDescriptor(Class<?> beanClass, String propertyName) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < propertyDescriptors.length) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            if (descriptor.getName().equals(propertyName)) {
                return descriptor;
            }
            ++i;
        }
        throw new BindingException(MessageFormat.format("Could not find property with name {0} in class {1}", propertyName, beanClass));
    }
}

